#include <iostream>
#include <vector>
#include <algorithm>
#include <sstream> // std::istringstream
#include <limits> // std::numeric_limits

using namespace std;

struct Jarbol {
    int x, h;
    int prethodni_indeks;
    int udaljenost = -1;

    Jarbol() {}

    Jarbol(int _x, int _h, int _prethodni_indeks) {
        x = _x;
        h = _h;
        prethodni_indeks = _prethodni_indeks;
    }

    bool operator<(const Jarbol& j) {
        return x < j.x;
    }
};

int main() {

    int n;
    cin >> n;

    // Obrisi ostatak (do kraja linije) ulaznog buffer-a nakon citanja celih brojeva u prvom redu, kako bi se preslo u drugi red i tako naredni poziv getline() citao od pocetka drugog reda
    cin.ignore(numeric_limits<streamsize>::max(), '\n');

    vector<Jarbol> ulazni_jarbol(n);

    string red;
    int indeks, celi_broj;

    getline(cin, red);
    // cout << "Red 1: |" << red << "|" << endl;
    istringstream ss1(red);
    indeks = 0;
    while (ss1 >> celi_broj) {
        // cout << "celi broj " << celi_broj << endl;
        ulazni_jarbol[indeks] = Jarbol();
        ulazni_jarbol[indeks].x = celi_broj;
        ulazni_jarbol[indeks].prethodni_indeks = indeks;

        indeks++;
    }

    getline(cin, red);
    // cout << "Red 2: |" << red << "|" << endl;
    istringstream ss2(red);
    indeks = 0;
    while (ss2 >> celi_broj) {
        // cout << "celi broj " << celi_broj << endl;
        ulazni_jarbol[indeks].h = celi_broj;

        // cout << "ulazni_jarbol[" << indeks << "] x: " << ulazni_jarbol[indeks].x << ", h: " << ulazni_jarbol[indeks].h << ", prethodni_indeks: " << ulazni_jarbol[indeks].prethodni_indeks << ", udaljenost: " << ulazni_jarbol[indeks].udaljenost << endl;

        indeks++;
    }

    /*
    for (int i = 0; i < n; i++) {
        cout << (i + 1) << ". ulazni jarbol (" << ulazni_jarbol[i].x << ", " << ulazni_jarbol[i].h << ")" << endl;
    }
    cout << endl;
    */

    vector<Jarbol> jarbol(ulazni_jarbol);
    sort(jarbol.begin(), jarbol.end());

    /*
    for (int i = 0; i < n; i++) {
        cout << (i + 1) << ". sortirani jarbol (" << jarbol[i].x << ", " << jarbol[i].h << ")" << endl;
    }
    cout << endl;
    */

    int dx, dh;
    for (int i = 0; i < n - 1; i++) { // za jarbol najdalji od pramca je izlazni rezultat uvek -1
        // cout << (i + 1) << ". sortirani jarbol (" << jarbol[i].x << ", " << jarbol[i].h << ") i naredni sortirani " << (i + 2) << ". jarbol (" << jarbol[i + 1].x << ", " << jarbol[i + 1].h << ")" << endl;
        dx = jarbol[i + 1].x - jarbol[i].x;

        // cout << "dx = " << dx << endl;

        if (dx < 2) {
            // udaljenost je vec postavljena na -1 u atributima klase Jarbol
            continue;
        }

        dh = jarbol[i + 1].h - jarbol[i].h;
        // cout << "dh = " << dh << endl;

        if (dh >= 0 && dx > dh) {
            ulazni_jarbol[jarbol[i].prethodni_indeks].udaljenost = dx - dh;
        } else {
            // V1 udaljenost vec postavljena na -1 u atributima klase Jarbol

            // V2
            // ulazni_jarbol[jarbol[i].prethodni_indeks].udaljenost = 0;
        }

    }

    /*
    for (int i = 0; i < n; i++) {
        cout << "obradjeni jarbol[" << i << "] x: " << jarbol[i].x << ", h: " << jarbol[i].h << ", prethodni_indeks: " << jarbol[i].prethodni_indeks << ", udaljenost: " << jarbol[i].udaljenost << endl;
    }
    */

    for (int i = 0; i < n - 1; i++) {
        // cout << "ulazni_jarbol[" << indeks << "] x: " << ulazni_jarbol[indeks].x << ", h: " << ulazni_jarbol[indeks].h << ", prethodni_indeks: " << ulazni_jarbol[indeks].prethodni_indeks << ", udaljenost: " << ulazni_jarbol[indeks].udaljenost << endl;
        cout << ulazni_jarbol[i].udaljenost << endl;
    }
    cout << -1 << endl;

    return 0;
}